# SPDX-FileCopyrightText: 2021 ladyada for Adafruit Industries
# SPDX-License-Identifier: MIT
import gc
import board
import displayio
from adafruit_display_shapes.rect import Rect
from adafruit_display_shapes.circle import Circle
from adafruit_display_shapes.roundrect import RoundRect
from adafruit_display_shapes.triangle import Triangle
from adafruit_display_shapes.line import Line
from adafruit_display_shapes.polygon import Polygon
import terminalio
import adafruit_ili9341
import vectorio

# Release any resources currently in use for the displays
displayio.release_displays()

spi = board.SPI()
tft_cs = board.D9
tft_dc = board.D10

display_bus = displayio.FourWire(spi, command=tft_dc, chip_select=tft_cs, reset=board.D6)
display = adafruit_ili9341.ILI9341(display_bus, width=320, height=240, rotation=180)

# Make the display context
splash = displayio.Group()
display.show(splash)

# Make a background color fill
color_bitmap = displayio.Bitmap(320, 240, 1)
color_palette = displayio.Palette(1)
color_palette[0] = 0xFFFFFF
bg_sprite = displayio.TileGrid(color_bitmap, x=0, y=0, pixel_shader=color_palette)
splash.append(bg_sprite)
##########################################################################
last_free = gc.mem_free()
splash.append(Line(220, 130, 270, 210, 0xFF0000))
free = gc.mem_free()
print( "Line:" )
print( last_free - free )
splash.append(Line(270, 210, 220, 210, 0xFF0000))
splash.append(Line(220, 210, 270, 130, 0xFF0000))
splash.append(Line(270, 130, 220, 130, 0xFF0000))

print(len(splash))
last_free = gc.mem_free()
# Draw a blue star
polygon = Polygon(
    [
        (255, 40),
        (262, 62),
        (285, 62),
        (265, 76),
        (275, 100),
        (255, 84),
        (235, 100),
        (245, 76),
        (225, 62),
        (248, 62),
    ],
    outline=0x0000FF,
)
splash.append(polygon)
free = gc.mem_free()
print( "Polygon:" )
print( last_free - free )
print(len(splash))

last_free = gc.mem_free()
triangle = Triangle(170, 50, 120, 140, 210, 160, outline = 0x000000)#fill=0x00FF00, outline=0xFF00FF)
splash.append(triangle)
free = gc.mem_free()
print( "Triangle:" )
print( last_free - free )

rect = Rect(80, 20, 41, 41, fill=0x0)
splash.append(rect)

last_free = gc.mem_free()
circle = Circle(100, 100, 10, fill=0x00FF00 )#, outline=0xFF00FF)
splash.append(circle)
free = gc.mem_free()
print( "Circle:" )
print( last_free - free )

rect2 = Rect(50, 100, 61, 81, outline=0x0, stroke=3)
splash.append(rect2)

roundrect = RoundRect(10, 10, 61, 81, 10, fill=0x0, outline=0xFF00FF, stroke=6)
splash.append(roundrect)


last_free = gc.mem_free()
palette = displayio.Palette(1)
palette[0] = 0x125690

points2 = [ (255, 40), (262, 62), (285, 62), (265, 76), (275, 100), (255, 84), (235, 100), (245, 76), (225, 62), (248, 62)]
polygon = vectorio.Polygon(pixel_shader=palette, points=points2, x=0, y=50)
splash.append(polygon)
free = gc.mem_free()
print( "Polygon2:" )
print( last_free - free )

while True:
    pass
